//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct st_Register
{
    uchar       ID;
    string      Name,
                Surname,
                Address,
                Position;
    double      Remuneration;
    datetime    Birth,
                Hiring;
}gl_Record[10];
//+------------------------------------------------------------------+
void OnStart(void)
{
    uchar Index;

    ZeroMemory(gl_Record);

    NewCollaborator("Daniel", "Jose", "Brasil", "1971/03/30", "Chief Programmer");
    NewCollaborator("Edimarcos", "Alcantra", "Brasil", "1974/12/07", "Programmer");
    NewCollaborator("Carlos", "Almeida", "Brasil", "1985/11/15", "Junior Programmer");

    Index = GetNumberRecord();

    if (NewRecord(gl_Record[Index], "Yara", "Alves", "Brasil", "1978/07/25"))
    {
        gl_Record[Index].ID = Index + 1;
        gl_Record[Index] = UpdatePosition(gl_Record[Index], "Accounting");
    }

    Print("Number of records: ", GetNumberRecord());
    Print("--------------------");

    for(uchar c = 1; ViewRecord(c); c++)
        Print("********************");
}
//+------------------------------------------------------------------+
bool NewCollaborator(const string Name, const string Surname, const string Address, const string Birth, const string Position)
{
    st_Register info;
    uchar       Index = 0;

    if (!NewRecord(info, Name, Surname, Address, Birth))
        return false;

    info = UpdatePosition(info, Position);

    while (gl_Record[Index].ID)
    {
        if (Index >= gl_Record.Size()) return false;
        Index++;
    }

    info.ID = Index + 1;
    gl_Record[Index] = info;

    return true;
}
//+------------------------------------------------------------------+
bool NewRecord(st_Register &arg, const string Name, const string Surname, const string Address, const string Birth)
{
    arg.Name = Name;
    arg.Surname = Surname;
    arg.Address = Address;
    arg.Birth = StringToTime(Birth);
    arg.Hiring = TimeLocal();

    return true;
}
//+------------------------------------------------------------------+
st_Register UpdatePosition(const st_Register &arg, const string NewPosition)
{
    st_Register info = arg;

    info.Position = NewPosition;

    return info;
}
//+------------------------------------------------------------------+
uchar GetNumberRecord(void)
{
    uchar counter = 0;

    for (uchar c = 0; c < gl_Record.Size(); counter += (gl_Record[c].ID ? 1 : 0), c++);

    return counter;
}
//+------------------------------------------------------------------+
bool ViewRecord(const uchar ID)
{
    st_Register info;

    ZeroMemory(info);

    for (uchar c = 0; (c < gl_Record.Size()) && (!info.ID); c++)
        info = (gl_Record[c].ID == ID ? gl_Record[c] : info);

    if (info.ID)
        PrintFormat("Collaborator: %s, %s\nPosition: %s\nBirth in: %s",
                        info.Surname,
                        info.Name,
                        info.Position,
                        TimeToString(info.Birth, TIME_DATE));
    else
        Print("Record ID [", ID ,"] not found.");

    return (bool) info.ID;
}
//+------------------------------------------------------------------+